/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.util.Version;

public class Oratab
extends OracleServiceRegistry {
    public static final File DEFAULT_ORATAB_PATH = new File("/etc/oratab");
    private File path;
    private static final Logger logger = Logger.getLogger(Oratab.class.getName());

    public Oratab() {
        this(null);
    }

    public Oratab(File path) {
        this.path = path == null ? DEFAULT_ORATAB_PATH : path;
    }

    @Override
    public OracleService findServiceById(Pattern pattern) {
        if (pattern != null) {
            List<OracleService> serviceList = this.getServices();
            for (OracleService service : serviceList) {
                Matcher matcher = pattern.matcher(service.getSid());
                if (!matcher.matches()) continue;
                return service;
            }
        }
        return null;
    }

    @Override
    public OracleService findServiceById(String sid) {
        if (sid != null) {
            List<OracleService> serviceList = this.getServices();
            for (OracleService service : serviceList) {
                if (!sid.equals(service.getSid())) continue;
                return service;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OracleService> getServices() {
        ArrayList<OracleService> services = new ArrayList<OracleService>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.path));
            String line = null;
            OracleService service = null;
            while ((line = in.readLine()) != null) {
                service = Oratab.translate(line);
                if (service == null) continue;
                services.add(service);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINEST, "Error while reading the service registry. Cause: {0}", e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.log(Level.FINEST, "Error while reading the service registry. Cause: {0}", e.getMessage());
                }
            }
        }
        return services;
    }

    private static OracleService translate(String line) {
        String[] tokens;
        OracleService entry = null;
        if ((line = line.trim()).length() > 0 && !line.startsWith("#") && (tokens = line.split(":")).length >= 3) {
            entry = new OracleService(tokens[0], new File(tokens[1]), Version.UNKNOWN, tokens[2].equals("Y"));
        }
        return entry;
    }
}

